<?php

include_once 'conexao.php';
 
class ModeloRespostaEntrevista 
{    
	static public function mdlAddRespostaEntrevista($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO respostaentrevista 
						(idResposta, idCandidato, dataCadastro,idVaga) VALUES (:idResposta, :idCandidato, :dataCadastro,:idVaga)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":idResposta", $dados["idResposta"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idCandidato", $dados["idUsuario"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error"; 
		}

	}

	static public function mdlAddRespostaAvaliacao($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO respostaentrevista 
						(idResposta, idCandidato, dataCadastro,idVaga,idTemaAvaliacao) VALUES (:idResposta, :idCandidato, :dataCadastro,:idVaga,:idTemaAvaliacao)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":idResposta", $dados["idResposta"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idCandidato", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":idTemaAvaliacao", $dados["idTema"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error"; 
		}

	}
 
	static public function mdlMostrarRespostasPorIdCandidatoEidVagaEIdResposta($idResposta,$idVaga,$idCandidato) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM respostaentrevista where idResposta = :idResposta and idVaga = :idVaga and idCandidato = :idCandidato");

		$stmt->bindParam(":idResposta", $idResposta, PDO::PARAM_STR);
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarRespostasAvaliacaoPorIdCandidatoEidVagaEIdRespostaEIdTema($idResposta,$idVaga,$idCandidato,$idTema) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM respostaentrevista where idResposta = :idResposta and idVaga = :idVaga and idCandidato = :idCandidato and idTemaAvaliacao = :idTema");
		$stmt->bindParam(":idResposta", $idResposta, PDO::PARAM_STR);
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
		$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasAsRespostasPorIdCandidatoEidVaga($idVaga,$idCandidato) {
 
		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM respostaentrevista where idVaga = :idVaga and idCandidato = :idCandidato");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	static public function mdlMostrarTodasAsRespostasDaAvaliacaoPorIdCandidatoEidVagaEIdTema($idVaga,$idCandidato, $idTema) {
 
		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM respostaentrevista where idVaga = :idVaga and idCandidato = :idCandidato and idTemaAvaliacao = :idTema ");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idCandidato", $idCandidato, PDO::PARAM_STR);
		$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
		$stmt ->execute();
		
		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	

	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>